<?php
/**
 * Script to add Vazirmatn font to all PHP files
 */

echo "<!DOCTYPE html><html><head><meta charset='UTF-8'></head><body>";
echo "<h1>🔧 اضافه کردن فونت Vazirmatn به همه صفحات</h1>";
echo "<style>body{font-family:Tahoma;padding:20px;direction:rtl;line-height:2;} .success{color:green;} .error{color:red;} .warning{color:orange;}</style>";

$fontImport = "@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');";

$fontCSS = "
body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label, td, th {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: \"Font Awesome 6 Free\", \"Font Awesome 6 Brands\" !important;
}
";

$files = [
    'admin/index.php',
    'admin/users.php',
    'admin/orders.php',
    'admin/settings.php',
    'admin/esims.php',
    'admin/cancel-esim-manual.php',
    'proxy-payment.php',
];

$updated = 0;
$skipped = 0;
$errors = 0;

foreach ($files as $file) {
    $filePath = __DIR__ . '/' . $file;
    
    echo "<h3>📄 $file</h3>";
    
    if (!file_exists($filePath)) {
        echo "<p class='error'>❌ فایل وجود ندارد</p>";
        $errors++;
        continue;
    }
    
    $content = file_get_contents($filePath);
    
    // Check if already has Vazirmatn
    if (strpos($content, 'Vazirmatn') !== false) {
        echo "<p class='warning'>⚠️ قبلاً فونت Vazirmatn دارد</p>";
        $skipped++;
        continue;
    }
    
    // Find <style> tag and add font
    if (preg_match('/<style>/', $content)) {
        // Add import before <style>
        $content = str_replace('<style>', '<style>' . "\n" . $fontImport . "\n" . $fontCSS, $content);
        
        if (file_put_contents($filePath, $content)) {
            echo "<p class='success'>✅ فونت اضافه شد</p>";
            $updated++;
        } else {
            echo "<p class='error'>❌ خطا در ذخیره فایل</p>";
            $errors++;
        }
    } else {
        echo "<p class='error'>❌ تگ &lt;style&gt; پیدا نشد</p>";
        $errors++;
    }
}

echo "<hr>";
echo "<h2>📊 خلاصه:</h2>";
echo "<p class='success'>✅ به‌روز شده: $updated فایل</p>";
echo "<p class='warning'>⚠️ رد شده: $skipped فایل</p>";
echo "<p class='error'>❌ خطا: $errors فایل</p>";
echo "<hr>";
echo "<h2>✅ تمام شد!</h2>";
echo "<p><a href='/admin/'>رفتن به پنل مدیریت</a></p>";
echo "</body></html>";
?>

